from itertools import combinations
def orijentacija(p, q, r):
    return (q[1] - p[1]) * (r[0] - q[0]) - (q[0] - p[0]) * (r[1] - q[1])
def konveksni_omotac(tacke):
    tacke = sorted(tacke)
    if len(tacke) <= 1:
        return tacke

    donji = []
    for p in tacke:
        while len(donji) >= 2 and orijentacija(donji[-2], donji[-1], p) <= 0:
            donji.pop()
        donji.append(p)

    gornji = []
    for p in reversed(tacke):
        while len(gornji) >= 2 and orijentacija(gornji[-2], gornji[-1], p) <= 0:
            gornji.pop()
        gornji.append(p)

    return donji[:-1] + gornji[:-1]
def povrsina_mnogougla(mnogougao):
    povrsina = 0
    n = len(mnogougao)
    for i in range(n):
        j = (i + 1) % n
        povrsina += mnogougao[i][0] * mnogougao[j][1]
        povrsina -= mnogougao[j][0] * mnogougao[i][1]
    return abs(povrsina) // 2
n = int(input())
tacke = [tuple(map(int, input().split())) for _ in range(n)]
minimalna_povrsina = float('inf')
for podskup in combinations(tacke, n - 1):
    omotac = konveksni_omotac(list(podskup))
    povrsina = povrsina_mnogougla(omotac)
    minimalna_povrsina = min(minimalna_povrsina, povrsina)

print(minimalna_povrsina)